<?php

namespace App\Models\Data;

use Illuminate\Database\Eloquent\Model;

class Stock extends Model 
{

    protected $table = 'stocks';
    public $timestamps = true;
    protected $fillable = array('expired_date', 'stock', 'created_by', 'updated_by');

    public function product()
    {
        return $this->belongsTo('Product', 'product_id', 'id');
    }

    public function location()
    {
        return $this->belongsTo('Location', 'location_id', 'id');
    }

}